// vite.config.js
import {defineConfig} from "vite";

import path from "path";
import * as fs from "fs";


export default defineConfig({
    sourcemap: true,
    plugins: [],
    resolve: {},
    build: {
        manifest: true,
        minify: true,
        reportCompressedSize: true,
        lib: {
            name: 'javascript-signature-sdk',
            entry: path.resolve(__dirname, "signature-sdk.js"),
            fileName: "signature-sdk",
            formats: ["cjs", "umd"],
        },
		rollupOptions: {},
		//this is not working, the assests are know in a public folder
        //after: () => {
        //     Use fs-extra to copy the .wasm file to the dist directory
        //    fs.copy(path.resolve(__dirname, "signature_sdk.wasm"), path.resolve(__dirname, "dist/signature_sdk.wasm"), (err) => {
        //        if (err) {
        //            console.error("Error copying .wasm file:", err);
        //        } else {
        //            console.log(".wasm file copied to dist directory.");
        //        }
        //    });
        //},
    }
});