<?php
if (isset($_POST['type']) && ($_POST['type'] == "get_time")) {

	$op  = array('is_success' => false, 'data' => 0);

	require_once "models/db_connect.php";
	date_default_timezone_set('Asia/Baghdad');


	$login_time = date('Y-m-d H:i:s');
	$ip = $_SERVER["REMOTE_ADDR"];

	$ip = mysqli_real_escape_string($db, $ip);


	$sql = "SELECT 	login_timestamp
			FROM ip_login 
			WHERE  ip_address = ? 
			ORDER BY login_timestamp DESC
			LIMIT 1";

	$res = $db->prepare($sql);

	if ($res) {
		$res->bind_param('s', $ip);
		$res->execute();
		$res->store_result();

		if ($res->num_rows > 0) {
			$res->bind_result($login_timestamp);
			$res->fetch();

			$diff = 10 - (strtotime($login_time) - strtotime($login_timestamp)) / 60;
			$op['data'] = $diff;
			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		}
	}
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Limit Login Attempts</title>

	<!-- Global stylesheets -->
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
	<link href="assets/css/icons/icomoon/styles.css" rel="stylesheet" type="text/css">
	<link href="assets/css/bootstrap.css" rel="stylesheet" type="text/css">
	<link href="assets/css/core.css" rel="stylesheet" type="text/css">
	<link href="assets/css/components.css" rel="stylesheet" type="text/css">
	<link href="assets/css/colors.css" rel="stylesheet" type="text/css">
	<!-- /global stylesheets -->

	<!-- Core JS files -->
	<script type="text/javascript" src="assets/js/plugins/loaders/pace.min.js"></script>
	<script type="text/javascript" src="assets/js/core/libraries/jquery.min.js"></script>
	<script type="text/javascript" src="assets/js/core/libraries/bootstrap.min.js"></script>
	<script type="text/javascript" src="assets/js/plugins/loaders/blockui.min.js"></script>
	<!-- /core JS files -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="assets/js/plugins/forms/validation/validate.min.js"></script>
	<script type="text/javascript" src="assets/js/plugins/forms/styling/uniform.min.js"></script>

	<script type="text/javascript" src="assets/js/plugins/notifications/pnotify.min.js"></script>
	<script type="text/javascript" src="assets/js/plugins/notifications/noty.min.js"></script>
	<script type="text/javascript" src="assets/js/plugins/notifications/jgrowl.min.js"></script>
	<script type="text/javascript" src="assets/js/plugins/internationalization/i18next.min.js"></script>
	<script type="text/javascript" src="assets/js/core/app.js"></script>
	<script type="text/javascript" src="assets/js/pages/internationalization_switch_direct.js"></script>



</head>






<body>

	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">
			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Content area -->
				<div class="content pb-20">


					<div class="panel panel-body login-form">
						<div class="text-center">
							<div class="icon-object border-danger text-danger"><i class="icon-user-block"></i></div>
							<h5 class="content-group">Temporarily Limit Login<small class="display-block">Your IP Address Have Been Temporarily Banneded for 10 Minutes, You Tried 30 attempts within less than 10 minutes</small></h5>
						</div>




						<div class="form-group login-options">
							<div class="row">
								<div class="col-sm-12 text-center">
									<label class="checkbox-inline text-center">

										<div>
											<span class="count-digit">0</span>
											<span class="count-digit">0</span>
											<span class="separator">:</span>
											<span class="count-digit">0</span>
											<span class="count-digit">0</span>
										</div>
									</label>
								</div>

							</div>
						</div>

						<div class="form-group">
							<a href="login.php" class="btn bg-blue btn-block">Go to Login <i class="icon-arrow-right14 position-right"></i></a>
						</div>




						<span class="help-block text-center no-margin">By continuing, you're confirming that you've read our <a href="#">Terms &amp; Conditions</a> and <a href="#">Cookie Policy</a></span>
					</div>


				</div>
				<!-- /content area -->

			</div>
			<!-- /main content -->

		</div>
	</div>
</body>
<script>
	function get_Time() {
		$.ajax({
			url: 'attemp-limit.php',
			type: 'POST',
			data: {
				type: 'get_time'
			},
			dataType: 'json',
			success: function(response) {

				var mint = response.data;

				if (mint > 0) {

					// Select Every Count Container
					const countContainer = document.querySelectorAll(".count-digit");

					// Select option buttons
					const startAction = document.getElementById("start-timer");
					const stopAction = document.getElementById("stop-timer");
					const resetAction = document.getElementById("reset-timer");


					// Default inital value of timer
					const defaultValue = mint * 60;

					// variable to the time
					var countDownTime = defaultValue;

					// variable to store time interval
					var timerID;

					// Variable to track whether timer is running or not
					var isStopped = true;

					// Function calculate time string
					const findTimeString = () => {
						var minutes = String(Math.trunc(countDownTime / 60));
						var seconds = String(countDownTime % 60);
						if (minutes.length === 1) {
							minutes = "0" + minutes;
						}
						if (seconds.length === 1) {
							seconds = "0" + seconds;
						}
						return minutes + seconds;
					};

					// Function to start Countdown
					const startTimer = () => {
						if (isStopped) {
							isStopped = false;
							timerID = setInterval(runCountDown, 1000);
						}
					};

					// Function to stop Countdown
					const stopTimer = () => {
						isStopped = true;
						if (timerID) {
							clearInterval(timerID);
						}
					};

					// Function to reset Countdown
					const resetTimer = () => {
						stopTimer();
						countDownTime = defaultValue;
						renderTime();
					};




					// Function to display coundown on screen
					const renderTime = () => {
						const time = findTimeString();
						countContainer.forEach((count, index) => {
							count.innerHTML = time.charAt(index);
						});
					};

					// function to execute timer
					const runCountDown = () => {
						// decement time
						countDownTime -= 1;
						//Display updated time
						renderTime();

						// timeout on zero
						if (countDownTime <= 0) {
							stopTimer();
							// Play alarm on timeout
							countDownTime = defaultValue;
							window.location = 'login.php';
						}
					};

					startTimer()
				} else {
					window.location = 'login.php';
				}


			},
			complete: function() {
				//  me.data('requestRunning', false);
			}

		}); // submit ajax
	}

	$(document).ready(function() {

		get_Time();

	});
</script>

</html>