/* ------------------------------------------------------------------------------
*
*  # Login form with validation
*
*  Specific JS code additions for login_validation.html page
*
*  Version: 1.0
*  Latest update: Aug 1, 2015
*
* ---------------------------------------------------------------------------- */

$(function() {

    if (localStorage.chkbx && localStorage.chkbx != '') {
        $('#chkbx').attr('checked', 'checked');
        $('#username').val(localStorage.username);
        $('#password').val(localStorage.password);
    } else {
        $('#chkbx').removeAttr('checkedd');
        $('#username').val('');
        $('#password').val('');
    }

    $('#chkbx').click(function() {
        if ($('#chkbx').is(':checked')) {
            localStorage.username = $('#username').val();
            localStorage.password = $('#password').val();
            localStorage.chkbx = $('#chkbx').val();
        } else {
            localStorage.username = '';
            localStorage.password = '';
            localStorage.chkbx = '';
        }
    });

	// Style checkboxes and radios
	$('.styled').uniform();



    // Setup validation
    $(".form-validate").validate({
        ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
        errorClass: 'validation-error-label',
        successClass: 'validation-valid-label',
        highlight: function(element, errorClass) {
            $(element).removeClass(errorClass);
        },
        unhighlight: function(element, errorClass) {
            $(element).removeClass(errorClass);
        },

        // Different components require proper error label placement
        errorPlacement: function(error, element) {

            // Styled checkboxes, radios, bootstrap switch
            if (element.parents('div').hasClass("checker") || element.parents('div').hasClass("choice") || element.parent().hasClass('bootstrap-switch-container') ) {
                if(element.parents('label').hasClass('checkbox-inline') || element.parents('label').hasClass('radio-inline')) {
                    error.appendTo( element.parent().parent().parent().parent() );
                }
                 else {
                    error.appendTo( element.parent().parent().parent().parent().parent() );
                }
            }

            // Unstyled checkboxes, radios
            else if (element.parents('div').hasClass('checkbox') || element.parents('div').hasClass('radio')) {
                error.appendTo( element.parent().parent().parent() );
            }

            // Input with icons and Select2
            else if (element.parents('div').hasClass('has-feedback') || element.hasClass('select2-hidden-accessible')) {
                error.appendTo( element.parent() );
            }

            // Inline checkboxes, radios
            else if (element.parents('label').hasClass('checkbox-inline') || element.parents('label').hasClass('radio-inline')) {
                error.appendTo( element.parent().parent() );
            }

            // Input group, styled file input
            else if (element.parent().hasClass('uploader') || element.parents().hasClass('input-group')) {
                error.appendTo( element.parent().parent() );
            }

            else {
                error.insertAfter(element);
            }
        },
        validClass: "validation-valid-label",
        success: function(label) {
            label.addClass("validation-valid-label").text("Successfully")
        },
        rules: {
            password: {
                minlength: 6
            }
        },
        messages: {
            username: "Enter your username",
            password: {
            	required: "Enter your password",
            	minlength: jQuery.validator.format("At least {0} characters required")
            }
        }
    });

    $("#login_btn").on('click', function(e){
        e.preventDefault();
        $('#login_form').submit();
    })

    $('#login_form').submit(function(event) {
      event.preventDefault();

      var fd=new FormData(this);

      
      fd.append("type",'login');

      $("#login_btn").attr('disabled',true);
      $.ajax({
          url: "models/crul_login.php",
          type:"POST",
          dataType: "JSON",
          data: fd,
          processData: false,
          contentType: false
      
      })
      .done(function(res) {
         
        if(res.is_success == true){

            $("#login_form")[0].reset();

            var act  = res.action_id;

            // localStorage.setItem('user_action', act);

            noty({
                  width: 200,
                  text: i18n.t(res.data),
                  type: 'success',
                  dismissQueue: true,
                  timeout: 2000,
                  layout: 'topRight',
                  callback: {
                              onShow: function() {

                              },
                              afterShow: function() {
                               // show_report(res.id,'Print');
                              },
                              onClose: function() {

                                window.location='starter.php';

                              },
                              afterClose: function() {},
                              onCloseClick: function() {},
                            },
            });

         
        }else{
            noty({
                    width: 200,
                    text: i18n.t(res.data),
                    type: 'error',
                    dismissQueue: true,
                    timeout: 1000,
                    layout: 'topRight',
                    callback: {
                              onShow: function() {

                              },
                              afterShow: function() {
                               // show_report(res.id,'Print');
                              },
                              onClose: function() {

                                location.reload();

                              },
                              afterClose: function() {},
                              onCloseClick: function() {},
                            },
            });
        }

          $("#login_btn").attr('disabled',false);
      })
      .fail(function(err) {
          $("#login_btn").attr('disabled',false);

           swal({
              title: i18n.t("Error"),
              text: i18n.t(err),
              confirmButtonColor: "#66BB6A",
              type: "error"
          });
          $("#login_btn").attr('disabled',false);
      })
      .always(function() {
          console.log("complete");
          $("#login_btn").attr('disabled',false);

      });
      

  });

});
