<?php
// Set JSON content type and CORS headers
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");
require_once "db_connect.php";

$sys_res = $db->query("SELECT * FROM system_settings");
$sysinfo = $sys_res->fetch_assoc();

date_default_timezone_set($sysinfo['system_time_zone']);

// Function to return API responses
function sendResponse($success, $data, $httpCode = 200)
{
	http_response_code($httpCode);
	echo json_encode([
		'success' => $success,
		'data' => $data,
		'timestamp' => date("Y-m-d H:i:s")
	]);
	exit;
}

// Function to authenticate user
function authenticateUser($username, $password)
{
	global $db;

	$password 		= 	stripslashes($password);
	$password	=	mysqli_real_escape_string($db, $password);

	$stmt = $db->prepare("SELECT staff_id, username, password FROM staff WHERE username = ? AND is_deleted = 0");
	$stmt->bind_param("s", $username);
	$stmt->execute();
	$result = $stmt->get_result();

	if ($result->num_rows === 1) {
		$user = $result->fetch_assoc();
		// var_dump($user['password']);
		$verify = password_verify($password, $user['password']);
		// var_dump($verify);
		// exit;
		// Verify the CLEAN password against the stored hash
		if (password_verify($password, $user['password'])) {
			return [
				'authenticated' => true,
				'user_id' => $user['staff_id'],
				'username' => $user['username'],
			];
		}
	}

	return ['authenticated' => false];
}

function flippedMap($test_map)
{
	$flipped_map = [];
	foreach ($test_map as $name => $id) {
		if (!isset($flipped_map[$id])) {
			$flipped_map[$id] = [];
		}
		$flipped_map[$id][] = $name;
	}
	return $flipped_map;
}
function getResult($test_id, $test_mapping, $result)
{
	// Check if the test ID exists in the test mapping
	if (isset($test_mapping[$test_id])) {
		$test_names = $test_mapping[$test_id]; // Get the names associated with the test ID
		if (is_array($test_names)) {
			// If multiple names exist, find the one present in the result
			foreach ($test_names as $name) {
				if (isset($result[$name])) {
					return $result[$name]; // Return the result for the matching name
				}
			}
		} elseif (isset($result[$test_names])) {
			// If a single name exists, return the result for that name
			return $result[$test_names];
		}
	}
	return ''; // Return null if no match is found
}
// Get request data
$requestData = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	// Check if we have form data first
	if (!empty($_POST)) {
		$requestData = $_POST;
	} else {
		// If no form data, try to parse JSON
		$jsonInput = file_get_contents('php://input');
		if (!empty($jsonInput)) {
			$requestData = json_decode($jsonInput, true) ?? [];
		}
	}
} else {
	// Parse JSON input for other methods
	$jsonInput = file_get_contents('php://input');
	if (!empty($jsonInput)) {
		$requestData = json_decode($jsonInput, true) ?? [];
	}
}

// Check for credentials in request
if (!isset($requestData['username']) || !isset($requestData['password'])) {
	sendResponse(false, $requestData['username'], 401);
}

// Authenticate user
$auth = authenticateUser($requestData['username'], $requestData['password']);
if (!$auth['authenticated']) {
	sendResponse(false, "Invalid username or password", 401);
}

// Set user information
$user_id = $auth['user_id'];
$username = $auth['username'];

// Handle API operations
if (isset($requestData['device'])) {

	$lid = $requestData['lab_id'];
	$labquery = $db->query("SELECT L.lab_test_id as lab_id from lab_test as L
								WHERE L.is_deleted = 0 AND L.lab_test_id ='$lid'
								ORDER BY L.lab_test_date DESC
								LIMIT 1");

	$id = 0;
	$data = $labquery->fetch_all(MYSQLI_ASSOC);
	foreach ($data as $index => $row) {
		$id = $row['lab_id'];
	}
	if ($id === 0) {
		sendResponse(false, "Lab test id not found", 404);
	}

	$device = mysqli_real_escape_string($db, $requestData['device']);
	$test = $requestData['test'];
	$result = $requestData['result'];
	$reg_date 		= date("Y-m-d H:i:s", time());
	$res = $db->query("SELECT * FROM lab_test WHERE lab_test_id=$id");
	$lastaction = "Update Test information by Lab Device";
	$by 		= $user_id;
	$srepo = " sample_reported_on='$reg_date', ";
	$update_qry = "UPDATE lab_test SET 
								$srepo
								last_action 			='$lastaction',
								updated_at				='$reg_date',
								last_action_by			='$by' 
								WHERE lab_test_id 	= $id";
	$update_lab_test_detail = "UPDATE lab_test_detail SET 
								last_action 			='$lastaction',
								updated_at				='$reg_date',
								last_action_by			='$by' 
								WHERE lab_test_id_fk 	= $id";
	$update_lab_test_detail_item = "UPDATE lab_test_detail_item SET 
									last_action 			='$lastaction',
									updated_at				='$reg_date',
									last_action_by			='$by' 
									WHERE lab_test_id_fk 	= $id";

	// Test type to product_id_fk mapping except for cbc which is product id the parameter is product_detail_id
	$cbc_test_map = [
		// Beckman Coulter DXH500
		'cbc' => 2,
		'RBC' => 125,
		'HGB' => 128,
		'HCT' => 129,
		'MCV' => 130,
		'MCH' => 131,
		'MCHC' => 132,
		'RDW' => 133,
		'WBC' => 134,
		'NE#' => 135,
		'NE' => 136,
		'LY#' => 137,
		'LY' => 138,
		'MO#' => 139,
		'MO' => 140,
		'EO#' => 141,
		'EO' => 142,
		'BA#' => 143,
		'BA' => 144,
		'PLT' => 145,
		'MPV' => 146
	];

	$vidas_test_map = [
		// minividas
		'Vitamin D' => 28,
		'VB12' => 23,
		'Ferritin' => 22,
		'AMH' => 1310,
		'D-Dimer' => 26,
		'TOXO IgG' => 86,
		'TOXO IgM' => 87
	];
	$vidas_test_detail_map = [
		// minividas
		'TOXO IgG' => 441,
		'TOXO IgM' => 442
	];

	$cobas_test_map = [
		// cobas
		'ALB2' => 43,
		'ALTL' => 38,
		'BILD2' => 36,
		'ASTL' => 39,
		'BILT3' => 35,
		'CRP4' => 77,
		'CREJ2' => 33,
		'GGTI2' => 41,
		'HDLC4' => 47,
		'IRON2' => 19,
		'LDLC3' => 48,
		'MG-2' => 55,
		'TP2M' => 42,
		'TRIGL' => 46,
		'UA2' => 34,
		'UREL' => 32,
		'CHO2I' => 45,
		'HBA1C A1CW3' => 31,
		'AMYL2' => 49,
		'CKMB2' => 53,
		'GLU2' => 30, //Fasting , 'GLU2' => 1982, //Random
		'CA2' => 62,
		'LIP' => 156,
		'ALP2S' => 40,
		'LDHI2' => 52
	];
	$cobas_test_detail_map = [
		// cobas
		'ALTL' => 250,
		'ASTL' => 251,
		'ALP2S' => 252,
		'GGTI2' => 253,
		'BILT3' => 254,
		'BILD2' => 255,
		'TP2M' => 257,
		'ALB2' => 258,
		'CREJ2' => 235,
		'UREL' => 236,
		'CHO2I' => 221,
		'TRIGL' => 228,
		'HDLC4' => 229,
		'LDLC3' => 230
	];

	$maglumi_test_map = [
		// maglumi
		"25-OH VD II" => 28,
		"AMH II" => 1310,
		"Anti-HCV II" => 84,
		"CA125 II" => 71,
		"CMV IgG" => 90,
		"CMV IgM" => 91,
		"cTnI II" => 1408,
		"D-Dimer II" => 26,
		"DHEA-S II" => 107,
		"E2 II" => 112,
		"FA II" => 24,
		"Ferritin II" => 22,
		"FSH II" => 110,
		"F-T II" => 1472,
		"FT3 II" => 104,
		"FT4 II" => 105,
		"HBsAg Quant" => 78,
		"HBsAg Quant Nt" => 78,
		"HIV Ab/Ag Combi_" => 85,
		"HIV Combi" => 85,
		"hs-cTnI" => 1307,
		"hs-cTnl II" => 1307,
		"HSV-1/2 IgG II" => 1255,
		"HSV-1/2 IgM II" => 1256,
		"INS II" => 116,
		"LH II" => 109,
		"PRL II" => 111,
		"PROG II" => 113,
		"Rubella IgG" => 88,
		"Rubella IgM" => 89,
		"Rubella IgM_Mc" => 89,
		"T-B HCG II" => 108,
		"TEST II" => 2022,
		"TOXO IgG" => 86,
		"TOXO IgM" => 87,
		"TOXO IgM_Mc" => 87,
		"tPSA II" => 64,
		"Troponin I" => 1408,
		"TSH II" => 103,
		"TT3 II" => 101,
		"TT4 II" => 102,
		"Vit B12" => 23,
		"Vit B12 II" => 23
	];
	$maglumi_test_detail_map = [
		// maglumi
		"Troponin I" => 233,
		"cTnI II" => 234,
		"hs-cTnI" => 234,
		"hs-cTnl II" => 234,
		"TSH II" => 249,
		"TT3 II" => 319,
		"TT4 II" => 318,
		"Anti-HCV II" => 244,
		"HBsAg Quant" => 245,
		"HBsAg Quant Nt" => 245,
		"HIV Ab/Ag Combi_" => 246,
		"HIV Combi" => 246,
		"CMV IgG" => 439,
		"CMV IgM" => 440,
		"TOXO IgG" => 441,
		"TOXO IgM" => 442,
		"TOXO IgM_Mc" => 442,
		"Rubella IgG" => 443,
		"Rubella IgM" => 444,
		"Rubella IgM_Mc" => 444,
		"HSV-1/2 IgG II" => 445,
		"HSV-1/2 IgM II" => 446,
	];

	$lyte_test_map = [
		// smartlyte
		'electrolyte' => 1413,
		"K" => 241,
		"Na" => 242,
		"Cl" => 243
	];

	$test_map = [];
	$test_detail_map = [];
	if ($device == "beckman coulter dxh500") $test_map = $cbc_test_map;
	else if ($device == "minividas") {
		$test_map = $vidas_test_map;
		$test_detail_map = $vidas_test_detail_map;
	} else if ($device == "cobas") {
		$test_map = $cobas_test_map;
		$test_detail_map = $cobas_test_detail_map;
	} else if ($device == "maglumi") {
		$test_map = $maglumi_test_map;
		$test_detail_map = $maglumi_test_detail_map;
	} else if ($device == "lyte") $test_map = $lyte_test_map;

	// if ($test && is_array($test)) {
	// 	$product_ids = [];
	// 	$product_detail_ids = [];
	// 	foreach ($test as $test_name) {
	// 		if (isset($test_map[$test_name])) {
	// 			if ($test_name == 'GLU2') {
	// 				$product_ids[] = 30;
	// 				$product_ids[] = 1982;
	// 			} else {
	// 				$product_ids[] = $test_map[$test_name];
	// 			}
	// 		}
	// 	}
	// 	$product_id_qry = !empty($product_ids) ? "P.product_id IN (" . implode(',', $product_ids) . ") and" : '';

	// 	foreach ($test as $test_name) {
	// 		if (isset($test_detail_map[$test_name])) {
	// 			$product_detail_ids[] = $test_detail_map[$test_name];
	// 		}
	// 	}
	// 	$product_detail_id_qry = !empty($product_detail_ids) ? "PD.product_detail_id IN (" . implode(',', $product_detail_ids) . ") and" : '';
	// } else {
	// 	$product_detail_id_qry = "PD.product_id_fk = $test_map[$test] and";
	// 	$product_id_qry = "P.product_id = $test_map[$test] and";
	// }

	$lab_test_items_query = "SELECT LDT.lab_test_detail_item_id,L.lab_test_id,PD.product_id_fk,P.product_name,PD.product_detail_id as test_id,PD.product_detail_name as test_name,LDT.item_test_result 
										FROM lab_test as L
										left join lab_test_detail_item as LDT on L.lab_test_id = LDT.lab_test_id_fk 
										left join product_detail as PD on PD.product_detail_id = LDT.product_detail_id_fk
										left join product as P on P.product_id = PD.product_id_fk
										where L.lab_test_id = $id;";

	// echo "SELECT LDT.lab_test_detail_item_id,L.lab_test_id,PD.product_id_fk,P.product_name,PD.product_detail_id as test_id,PD.product_detail_name as test_name,LDT.item_test_result 
	// 									FROM lab_test as L
	// 									left join lab_test_detail_item as LDT on L.lab_test_id = LDT.lab_test_id_fk 
	// 									left join product_detail as PD on PD.product_detail_id = LDT.product_detail_id_fk
	// 									left join product as P on P.product_id = PD.product_id_fk
	// 									where L.lab_test_id = $id;";
	// exit;

	$lab_test_query = "SELECT LD.lab_test_detail_id,P.product_id as test_id,L.lab_test_id,P.product_name as test_name,LD.test_result
											FROM lab_test as L
											left join lab_test_detail as LD on L.lab_test_id = LD.lab_test_id_fk 
											left join product as P on P.product_id = LD.product_id_fk
											where L.lab_test_id = $id;";

	// echo "SELECT LD.lab_test_detail_id,P.product_id as test_id,L.lab_test_id,P.product_name as test_name,LD.test_result
	// 										FROM lab_test as L
	// 										left join lab_test_detail as LD on L.lab_test_id = LD.lab_test_id_fk 
	// 										left join product as P on p.product_id = LD.product_id_fk
	// 										where $product_id_qry L.lab_test_id = $id;";
	// exit;

	// if ($device == "lyte" || $device == "beckman coulter dxh500") {
	// 	$lab_test_items_query_data = $db->query($lab_test_items_query);
	// 	$check_lab_test_item = $lab_test_items_query_data->fetch_all(MYSQLI_ASSOC);
	// 	if (count($check_lab_test_item) === 0) {
	// 		sendResponse(false, "Lab test item not found", 404);
	// 	}
	// }
	// if ($device == "minividas" || $device == "cobas" || $device == "maglumi") {
	// 	$lab_test_data = $db->query($lab_test_query);
	// 	$check_lab_test = $lab_test_data->fetch_all(MYSQLI_ASSOC);
	// 	if (count($check_lab_test) === 0) {
	// 		sendResponse(false, "Lab test not found", 404);
	// 	}
	// }

	if (is_string($result)) {
		$result = json_decode($result, true);
		if (json_last_error() !== JSON_ERROR_NONE) {
			sendResponse(false, "Invalid JSON format in result data", 400);
		}
	}

	if ($device == "beckman coulter dxh500") {
		$before_update = $res->fetch_assoc();
		$db->autocommit(FALSE);
		$res = $db->query($update_qry);

		if ($res) {
			$index_num 	=	0;
			$res = $db->query($update_lab_test_detail);
			$res = $db->query($update_lab_test_detail_item);

			$test_mapping = array_flip($test_map);
			// $test_mapping = [
			// 	'Red Blood Cells (RBCs)' => 'RBC',
			// 	'Haemoglobin (Hb)' => 'HGB',
			// 	'Haematocrit (Hct/PCV)' => 'HCT',
			// 	'Mean Cell Volume (MCV)' => 'MCV',
			// 	'Mean Cell Haemoglobin (MCH)' => 'MCH',
			// 	'Mean Cell Haemoglobin Concentration (MCHC)' => 'MCHC',
			// 	'Red Cell Distribution Width (RDW-CV)' => 'RDW',
			// 	'White Blood Cells (WBCs)' => 'WBC',
			// 	'Neutrophils' => 'NE#',
			// 	'Neutrophils%' => 'NE',
			// 	'Lymphocytes' => 'LY#',
			// 	'Lymphocytes%' => 'LY',
			// 	'Monocytes' => 'MO#',
			// 	'Monocytes%' => 'MO',
			// 	'Eosinophils' => 'EO#',
			// 	'Eosinophils%' => 'EO',
			// 	'Basophils' => 'BA#',
			// 	'Basophils%' => 'BA',
			// 	'Platelet' => 'PLT',
			// 	'Mean Platelet Volume (MPV)' => 'MPV'
			// ];

			$lab_test_items_query_data = $db->query($lab_test_items_query);
			$lab_test_items = $lab_test_items_query_data->fetch_all(MYSQLI_ASSOC);
			foreach ($lab_test_items as $index => $item) {

				$item_test_result = '';
				if (isset($test_mapping[$item['test_id']])) {
					$mapped_key = $test_mapping[$item['test_id']];
					$item_test_result = $result[$mapped_key] ?? '';

					$item_test_note 	= "";
					$lab_test_detail_item_id = $item['lab_test_detail_item_id'];

					if ($item_test_result != '' && $lab_test_detail_item_id > 0) {

						$update_qry = "UPDATE lab_test_detail_item SET 
									item_test_result		='$item_test_result',
									item_test_note			='$item_test_note',
									
									last_action 			='$lastaction',
									updated_at				='$reg_date',
									last_action_by			='$by' 
								WHERE lab_test_detail_item_id = $lab_test_detail_item_id";

						$res = $db->query($update_qry);

						if (!$res) {
							//loglog('Fail Update', "lab", $id, "$db->error", 'lab.php');

							sendResponse(false, "Error: Update Failed", 400);
							$db->rollback();
						}
					}
				}
			}

			$res = $db->query("SELECT * FROM lab_test WHERE lab_test_id=$id");

			$after_update = $res->fetch_assoc();

			$updated_columns 		= array_diff_assoc($after_update, $before_update);
			$updated_columns_before = array_diff_assoc($before_update, $after_update);

			//loglog('Update', "lab", $id, "Record Successfully Updated by Lab Device", 'lab.php', $updated_columns_before, $updated_columns);

			$db->commit();
			sendResponse(true, "Record Successfully Updated", 200);
		} else {
			sendResponse(false, "Error: Update Failed", 400);
		}
	} else if ($device == "minividas") {

		$before_update = $res->fetch_assoc();

		$db->autocommit(FALSE);

		$res = $db->query($update_qry);

		if ($res) {
			$index_num 	=	0;

			$res = $db->query($update_lab_test_detail);
			$res = $db->query($update_lab_test_detail_item);

			$test_mapping = array_flip($test_map);
			$test_detail_mapping = flippedMap($test_detail_map);

			// $test_mapping = [
			// 	'Vitamin D (25-OH Vitamin D) ' => 'Vitamin D',
			// 	'Vitamin B12' => 'rtVB12',
			// 	'Ferritin Level' => 'Ferritin Level',
			// 	'Anti‑Müllerian hormone (AMH)' => 'AMH',
			// 	'D-Dimer' => 'Dimer',
			// ];

			$lab_test_data = $db->query($lab_test_query);
			$lab_test = $lab_test_data->fetch_all(MYSQLI_ASSOC);

			foreach ($lab_test as $index => $row) {
				$test_result = $result[$test_mapping[$row['test_id']]] ?? '';
				$test_note 	= "";
				$lab_test_detail_id = $row['lab_test_detail_id'];

				if ($lab_test_detail_id > 0) {

					$update_qry = "UPDATE lab_test_detail SET 
									test_result		='$test_result',
									test_note			='$test_note',
									
									last_action 			='$lastaction',
									updated_at				='$reg_date',
									last_action_by			='$by' 
								WHERE lab_test_detail_id = $lab_test_detail_id";

					$res = $db->query($update_qry);

					if (!$res) {
						//loglog('Fail Update', "lab", $id, "$db->error", 'lab.php');

						sendResponse(false, "Error: Update Failed", 400);
						$db->rollback();
					}
				}

				$index_num++;
			}

			$lab_test_items_query_data = $db->query($lab_test_items_query);
			// if ($lab_test_items_query_data) {
			$lab_test_details = $lab_test_items_query_data->fetch_all(MYSQLI_ASSOC);
			foreach ($lab_test_details as $index => $row) {

				$item_test_result = getResult($row['test_id'], $test_detail_mapping, $result);
				$item_test_note 	= "";
				$lab_test_detail_item_id = $row['lab_test_detail_item_id'];

				if ($item_test_result != '' && $lab_test_detail_item_id > 0) {

					$update_qry = "UPDATE lab_test_detail_item SET 
											item_test_result		='$item_test_result',
											item_test_note			='$item_test_note',
											
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
										WHERE lab_test_detail_item_id = $lab_test_detail_item_id";

					$res = $db->query($update_qry);

					if (!$res) {
						//loglog('Fail Update', "lab", $id, "$db->error", 'lab.php');

						sendResponse(false, "Error: Update Failed", 400);
						$db->rollback();
					}
				}
			}

			$res = $db->query("SELECT * FROM lab_test WHERE lab_test_id=$id");

			$after_update = $res->fetch_assoc();

			$updated_columns 		= array_diff_assoc($after_update, $before_update);
			$updated_columns_before = array_diff_assoc($before_update, $after_update);

			//loglog('Update', "lab", $id, "Record Successfully Updated by Lab Device", 'lab.php', $updated_columns_before, $updated_columns);

			$db->commit();
			sendResponse(true, "Record Successfully Updated", 200);
		} else {
			sendResponse(false, "Error: Update Failed", 400);
		}
	} else if ($device == "cobas") {

		$before_update = $res->fetch_assoc();

		$db->autocommit(FALSE);

		$res = $db->query($update_qry);

		if ($res) {
			$res = $db->query($update_lab_test_detail);
			$res = $db->query($update_lab_test_detail_item);

			$test_mapping = flippedMap($test_map);
			$test_detail_mapping = flippedMap($test_detail_map);

			// $test_mapping = [
			// 	"Albumin (Alb)" => 'ALB2',
			// 	"Alanine Aminotransferase  (ALT/GPT)" => 'ALTL',
			// 	"Direct Bilirubin" => 'BILD2',
			// 	"Aspartate Aminotransferase (AST/GOT)" => 'ASTL',
			// 	"Total Bilirubin (TSB)" => 'BILT3',
			// 	"C-Reactive Protein (CRP)" => 'CRP4',
			// 	"Creatinine" => 'CREJ2',
			// 	"γ-Glutamyltransferase (GGT)" => 'GGTI2',
			// 	"High Density Lipoproteins (HDL)" => 'HDLC4',
			// 	"Iron Level" => 'IRON2',
			// 	"Low Density Lipoproteins (LDL)" => 'LDLC3',
			// 	"Magnesium (Mg)" => 'MG-2',
			// 	"Total Protein (TP)" => 'TP2M',
			// 	"Triglycerides" => 'TRIGL',
			// 	"Uric Acid" => 'UA2',
			// 	"Urea" => 'UREL',
			// 	"Total Cholesterol" => 'CHO21',
			// 	"Hemoglobin (Hb) A1c%" => 'HBA1C A1CW3',
			// 	"α-Amylase" => 'AMYL2',
			// 	"Creatine Kinase Myocardial Band (CK-MB/CPK-MB)" => 'CKMB2',
			// 	"Glucose (Fasting Glucose Level)" => 'GLU2', //Fasting 
			// 	"Glucose (Random Glucose Level) " => 'GLU2', //Random
			// 	"Calcium (Ca)" => 'CA2',
			// 	"Lipase Level" => 'LIP',
			// 	"Alkaline phosphatase (ALP)" => 'ALP2S',
			// 	"Lactate Dehydrogenase (LDH)" => 'LDHI2',
			// ];

			// echo $lab_test_query;
			// exit;
			$lab_test_query_data = $db->query($lab_test_query);
			$lab_test = $lab_test_query_data->fetch_all(MYSQLI_ASSOC);
			foreach ($lab_test as $index => $row) {

				$test_id = $row['test_id'] == 1982 ? 30 : $row['test_id']; // Handle the special case for GLU2
				$test_result = getResult($test_id, $test_mapping, $result);
				$test_note 	= "";
				$lab_test_detail_id = $row['lab_test_detail_id'];

				if ($test_result != '' && $lab_test_detail_id > 0) {

					$update_qry = "UPDATE lab_test_detail SET 
									test_result		='$test_result',
									test_note			='$test_note',
									
									last_action 			='$lastaction',
									updated_at				='$reg_date',
									last_action_by			='$by' 
								WHERE lab_test_detail_id = $lab_test_detail_id";

					$res = $db->query($update_qry);

					if (!$res) {
						//loglog('Fail Update', "lab", $id, "$db->error", 'lab.php');

						sendResponse(false, "Error: Update Failed", 400);
						$db->rollback();
					}
				}
			}

			$lab_test_items_query_data = $db->query($lab_test_items_query);
			$lab_test = $lab_test_items_query_data->fetch_all(MYSQLI_ASSOC);
			foreach ($lab_test as $index => $item) {

				$item_test_result = getResult($item['test_id'], $test_detail_mapping, $result);
				$item_test_note 	= "";
				$lab_test_detail_item_id = $item['lab_test_detail_item_id'];

				if ($item_test_result != '' && $lab_test_detail_item_id > 0) {

					$update_qry = "UPDATE lab_test_detail_item SET 
									item_test_result		='$item_test_result',
									item_test_note			='$item_test_note',
									
									last_action 			='$lastaction',
									updated_at				='$reg_date',
									last_action_by			='$by' 
								WHERE lab_test_detail_item_id = $lab_test_detail_item_id";

					$res = $db->query($update_qry);

					if (!$res) {
						//loglog('Fail Update', "lab", $id, "$db->error", 'lab.php');

						sendResponse(false, "Error: Update Failed", 400);
						$db->rollback();
					}
				}
			}

			$res = $db->query("SELECT * FROM lab_test WHERE lab_test_id=$id");

			$after_update = $res->fetch_assoc();

			$updated_columns 		= array_diff_assoc($after_update, $before_update);
			$updated_columns_before = array_diff_assoc($before_update, $after_update);

			//loglog('Update', "lab", $id, "Record Successfully Updated by Lab Device", 'lab.php', $updated_columns_before, $updated_columns);

			$db->commit();
			sendResponse(true, "Record Successfully Updated", 200);
		} else {
			sendResponse(false, "Error: Update Failed", 400);
		}
	} else if ($device == "maglumi") {

		$before_update = $res->fetch_assoc();

		$db->autocommit(FALSE);

		$res = $db->query($update_qry);

		if ($res) {
			$res = $db->query($update_lab_test_detail);
			$res = $db->query($update_lab_test_detail_item);

			$test_mapping = flippedMap($test_map);
			$test_detail_mapping = flippedMap($test_detail_map);

			// $test_mapping = [
			// 	"Vitamin D (25-OH Vitamin D) " 						=> "25-OH VD II",
			// 	"Anti‑Müllerian hormone (AMH)" 						=> "AMH II",
			// 	"Hepatitis C Antibody (Anti-HCV)" 					=> "Anti-HCV II",
			// 	"Carbohydrate Antigen 125 (CA 125)" 				=> "CA125 II",
			// 	"Cytomegalovirus (CMV) IgG" 						=> "CMV IgG",
			// 	"Cytomegalovirus (CMV) IgM" 						=> "CMV IgM",
			// 	"Troponin I " 										=> "cTnI II",
			// 	"D-Dimer" 											=> "D-Dimer II",
			// 	"Dehydroepiandrosterone sulfate (DHEA-S)" 			=> "DHEA-S II",
			// 	"Estradiol (E2)" 									=> "E2 II",
			// 	"Folate (Folic Acid)" 								=> "FA II",
			// 	"Ferritin Level" 									=> "Ferritin II",
			// 	"Follicle-stimulating hormone (FSH)" 				=> "FSH II",
			// 	"Free Testosterone " 								=> "F-T II",
			// 	"Free Triiodothyronine (FT3)" 						=> "FT3 II",
			// 	"Free Thyroxine (FT4)" 								=> "FT4 II",
			// 	"Hepatitis B Surface Antigen (HBsAg)" 				=> "HBsAg Quant",
			// 	"Hepatitis B Surface Antigen (HBsAg)" 				=> "HBsAg Quant Nt",
			// 	"HIV Antibody (1+2) & P24 Antigen" 					=> "HIV Ab/Ag Combi_",
			// 	"HIV Antibody (1+2) & P24 Antigen" 					=> "HIV Combi",
			// 	"High sensitivity Troponin T (HS-cTnT)" 			=> "hs-cTnI",
			// 	"High sensitivity Troponin T (HS-cTnT)" 			=> "hs-cTnl II",
			// 	"Herpes Simplex Virus (HSV) type 1&2, IgG" 			=> "HSV-1/2 IgG II",
			// 	"Herpes Simplex Virus (HSV) type 1&2, IgM " 		=> "HSV-1/2 IgM II",
			// 	"Insulin Level" 									=> "INS II",
			// 	"Luteinizing hormone (LH)" 							=> "LH II",
			// 	"Prolactin" 										=> "PRL II",
			// 	"Progesterone" 										=> "PROG II",
			// 	"Rubella IgG" 										=> "Rubella IgG",
			// 	"Rubella IgM" 										=> "Rubella IgM",
			// 	"Rubella IgM" 										=> "Rubella IgM_Mc",
			// 	"Beta-Human Chorionic Gonadotropin (bHCG or β-hCG)" => "T-B HCG II",
			// 	"Total Testoterone" 								=> "TEST II",
			// 	"Toxoplasma gondii IgG" 							=> "TOXO IgG",
			// 	"Toxo IgM" 											=> "TOXO IgM",
			// 	"Toxo IgM" 											=> "TOXO IgM_Mc",
			// 	"Total Prostatic Specific Antigen, Total (PSA)" 	=> "tPSA II",
			// 	"Troponin I " 										=> "Troponin I",
			// 	"Thyroid stimulating hormone (TSH)" 				=> "TSH II",
			// 	"Total Triiodothyronine (T3)" 						=> "TT3 II",
			// 	"Total Thyroxine (T4)" 								=> "TT4 II",
			// 	"Vitamin B12" 										=> "Vit B12",
			// 	"Vitamin B12" 										=> "Vit B12 II",
			// ];

			$lab_test_query_data = $db->query($lab_test_query);
			if ($lab_test_query_data) {
				$lab_test = $lab_test_query_data->fetch_all(MYSQLI_ASSOC);
				foreach ($lab_test as $index => $row) {

					$test_result = getResult($row['test_id'], $test_mapping, $result);
					$test_note 	= "";
					$lab_test_detail_id = $row['lab_test_detail_id'];

					if ($test_result != '' && $lab_test_detail_id > 0) {

						$update_qry = "UPDATE lab_test_detail SET 
										test_result		='$test_result',
										test_note			='$test_note',
										
										last_action 			='$lastaction',
										updated_at				='$reg_date',
										last_action_by			='$by' 
									WHERE lab_test_detail_id = $lab_test_detail_id";

						$res = $db->query($update_qry);

						if (!$res) {
							//loglog('Fail Update', "lab", $id, "$db->error", 'lab.php');

							sendResponse(false, "Error: Update Failed", 400);
							$db->rollback();
						}
					}
				}

				// var_dump($lab_test_items_query);
				// exit;
				$lab_test_items_query_data = $db->query($lab_test_items_query);
				// if ($lab_test_items_query_data) {
				$lab_test_details = $lab_test_items_query_data->fetch_all(MYSQLI_ASSOC);
				foreach ($lab_test_details as $index => $row) {

					$item_test_result = getResult($row['test_id'], $test_detail_mapping, $result);
					$item_test_note 	= "";
					$lab_test_detail_item_id = $row['lab_test_detail_item_id'];

					if ($item_test_result != '' && $lab_test_detail_item_id > 0) {

						$update_qry = "UPDATE lab_test_detail_item SET 
											item_test_result		='$item_test_result',
											item_test_note			='$item_test_note',
											
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
										WHERE lab_test_detail_item_id = $lab_test_detail_item_id";

						$res = $db->query($update_qry);

						if (!$res) {
							//loglog('Fail Update', "lab", $id, "$db->error", 'lab.php');

							sendResponse(false, "Error: Update Failed", 400);
							$db->rollback();
						}
					}
				}
				// }
			}

			$res = $db->query("SELECT * FROM lab_test WHERE lab_test_id=$id");

			$after_update = $res->fetch_assoc();

			$updated_columns 		= array_diff_assoc($after_update, $before_update);
			$updated_columns_before = array_diff_assoc($before_update, $after_update);

			//loglog('Update', "lab", $id, "Record Successfully Updated by Lab Device", 'lab.php', $updated_columns_before, $updated_columns);

			$db->commit();
			sendResponse(true, "Record Successfully Updated", 200);
		} else {
			sendResponse(false, "Error: Update Failed", 400);
		}
	} else if ($device == "lyte") {

		$before_update = $res->fetch_assoc();

		$db->autocommit(FALSE);

		$res = $db->query($update_qry);

		if ($res) {
			$res = $db->query($update_lab_test_detail);
			$res = $db->query($update_lab_test_detail_item);

			$test_mapping = array_flip($test_map);

			$lab_test_items_query_data = $db->query($lab_test_items_query);
			$lab_test = $lab_test_items_query_data->fetch_all(MYSQLI_ASSOC);
			foreach ($lab_test as $index => $item) {

				$item_test_result = $result[$test_mapping[$item['test_id']]] ?? '';
				$item_test_note 	= "";
				$lab_test_detail_item_id = $item['lab_test_detail_item_id'];

				if ($item_test_result != '' && $lab_test_detail_item_id > 0) {

					$update_qry = "UPDATE lab_test_detail_item SET 
									item_test_result		='$item_test_result',
									item_test_note			='$item_test_note',
									
									last_action 			='$lastaction',
									updated_at				='$reg_date',
									last_action_by			='$by' 
								WHERE lab_test_detail_item_id = $lab_test_detail_item_id";

					$res = $db->query($update_qry);

					if (!$res) {
						//loglog('Fail Update', "lab", $id, "$db->error", 'lab.php');

						sendResponse(false, "Error: Update Failed", 400);
						$db->rollback();
					}
				}
			}

			$res = $db->query("SELECT * FROM lab_test WHERE lab_test_id=$id");

			$after_update = $res->fetch_assoc();

			$updated_columns 		= array_diff_assoc($after_update, $before_update);
			$updated_columns_before = array_diff_assoc($before_update, $after_update);

			//loglog('Update', "lab", $id, "Record Successfully Updated by Lab Device", 'lab.php', $updated_columns_before, $updated_columns);

			$db->commit();
			sendResponse(true, "Record Successfully Updated", 200);
		} else {
			sendResponse(false, "Error: Update Failed", 400);
		}
	} else {
		sendResponse(false, "Device not registered", 404);
	}
} else {
	sendResponse(false, "Device not found", 404);
}
