<?php
if (!isset($_SESSION)) {
	session_start();
}
if (!isset($_SESSION['is_login'])) {
	header("location: login.php");
?>
	<script>
		window.location = "login.php";
	</script>
<?php
}


date_default_timezone_set($_SESSION['system_time_zone']);


if (isset($_POST['type']) || isset($_GET['type'])) {
	require_once "db_connect.php";

	if (isset($_GET['type']) && ($_GET['type'] == "load")) {

		$table  =  "(SELECT 
					ld.id, ld.instrument_type, ld.test_name, 
					ld.test_code, ld.is_detail, ld.is_active, 
					COALESCE(p.product_name, pd.product_detail_name) AS test_item_name,
					COALESCE(p.product_id, pd.product_id_fk) AS product_code, 
					COALESCE(p.product_name, p2.product_name) AS product_name  
					FROM lab_devices ld 
					LEFT JOIN product p ON ld.test_code = p.product_id AND ld.is_detail = 0 
					LEFT JOIN product_detail pd ON ld.test_code = pd.product_detail_id AND ld.is_detail = 1
					LEFT JOIN product p2 ON pd.product_id_fk = p2.product_id
						) AS ALLTBL";


		$primaryKey = 'id';
		$columns =  array(
			array('db' => 'id', 'dt' => 0),
			array('db' => 'instrument_type', 'dt' => 1),
			array('db' => 'test_name',  'dt' => 2),
			array('db' => 'test_item_name',  'dt' => 3),
			// array("db" => "test_code", "dt" => 4),
			array("db" => "product_code", "dt" => 4),
			array("db" => "product_name", "dt" => 5),
			array("db" => "is_detail", "dt" => 6),
			array("db" => "is_active", "dt" => 7),
		);



		$ords 		= '';
		$fltr 		= '';
		$limit 		= "";


		// SQL server connection information
		$sql_details = array(
			'user' => $mysql_user,
			'pass' => $mysql_password,
			'db'   => $mysql_db,
			'host' => $mysql_server
		);
		require('ssp.php');
		echo json_encode(
			// SSP::complex_optimized( $_GET, $sql_details, $table, $primaryKey, $columns ,$fltr, $ords, $limit )
			SSP::complex($_GET, $sql_details, $table, $primaryKey, $columns, null, '')

		);
		exit;
	}

	if ($_POST['type'] == "get_edit") {

		$op  = array('is_success' => false, 'data' => array());

		$id = $_POST['edited_id'];

		$res = $db->query("SELECT 
					ld.id, ld.instrument_type, ld.test_name, 
					ld.test_code, ld.is_detail, ld.is_active, 
					COALESCE(p.product_name, pd.product_detail_name) AS test_item_name,
					COALESCE(p.product_id, pd.product_id_fk) AS product_code, 
					COALESCE(p.product_name, p2.product_name) AS product_name  
					FROM lab_devices ld 
					LEFT JOIN product p ON ld.test_code = p.product_id AND ld.is_detail = 0 
					LEFT JOIN product_detail pd ON ld.test_code = pd.product_detail_id AND ld.is_detail = 1
					LEFT JOIN product p2 ON pd.product_id_fk = p2.product_id 
								WHERE id = $id ");
		if ($res) {
			while ($row = $res->fetch_assoc()) {
				$result['id'] 			= $row['id'];
				$result['instrument_type'] 			= $row['instrument_type'];
				$result['test_name'] 			= $row['test_name'];
				$result['test_code'] 			= $row['test_code'];
				$result['product_name'] 			= $row['product_name'];
				$result['test_item_name'] 			= $row['test_item_name'];
				$result['is_detail'] 			= $row['is_detail'];
				array_push($op['data'], $result);
			}
			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		} else {
			$op['is_success'] = false;
			$op['data'] = 'Error Has Occure';
			echo json_encode($op);
			exit;
		}
	}

	if ($_POST['type'] == "get_device_name") {

		$op  = array('is_success' => false, 'data' => array());

		$res = $db->query("
							SELECT DISTINCT(`instrument_type`) from lab_devices;
								");
		if ($res) {


			while ($row = $res->fetch_assoc()) {

				$result['device_name']  		= $row['instrument_type'];
				array_push($op['data'], $result);
			}
			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		} else {
			$op['is_success'] = false;
			$op['data'] 	  = $db->error;
			echo json_encode($op);

			exit;
		}
	}

	if ($_POST['type'] == "get_test_name") {

		$op  = array('is_success' => false, 'data' => array());

		$res = $db->query("
							SELECT DISTINCT(`test_name`) from lab_devices;
								");
		if ($res) {


			while ($row = $res->fetch_assoc()) {

				$result['test_name']  		= $row['test_name'];
				array_push($op['data'], $result);
			}
			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		} else {
			$op['is_success'] = false;
			$op['data'] 	  = $db->error;
			echo json_encode($op);

			exit;
		}
	}

	if ($_POST['type'] == "update") {

		$id 				 		= $_POST['edited_id'];
		$edit_test_name 	 		= $_POST["edit_test_name"];
		$edit_parameter 	 		= $_POST["edit_parameter"];


		$op  = array('is_success' => false, 'data' => '');

		$db->autocommit(FALSE);

		$update_qry = "UPDATE lab_devices SET 
								test_name		='$edit_test_name',
								is_detail		='$edit_parameter'
							WHERE id = $id";


		$res = $db->query($update_qry);
		if ($res) {
			loglog('Update', "lab_devices", $id, "Record Successfully Updated", 'lab_devices.php');

			$db->commit();
			$op['is_success'] = true;
			$op['data'] 	 	  = "Record Successfully Updated";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Update', "lab_devices", $id, "$db->error", 'lab_devices.php');

			$db->rollback();
			$op['is_success'] = false;
			$op['data'] 	  	= "Error: Update Failed";
			echo json_encode($op);
			exit;
		}
	}

	if ($_POST['type'] == "update_status") {

		$id 				 		= $_POST['edited_id'];
		$status 	 		= $_POST["status"];


		$op  = array('is_success' => false, 'data' => '');

		$db->autocommit(FALSE);

		$update_qry = "UPDATE lab_devices SET 
								is_active		='$status'
							WHERE id = $id";


		$res = $db->query($update_qry);
		if ($res) {
			loglog('Update', "lab_devices", $id, "Record Successfully Updated", 'lab_devices.php');

			$db->commit();
			$op['is_success'] = true;
			$op['data'] 	 	  = "Record Successfully Updated";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Update', "lab_devices", $id, "$db->error", 'lab_devices.php');

			$db->rollback();
			$op['is_success'] = false;
			$op['data'] 	  	= "Error: Update Failed";
			echo json_encode($op);
			exit;
		}
	}

	if ($_POST['type'] == "delete") {

		$id 		= ($_POST["obj_id"]);

		$op  = array('is_success' => false, 'data' => '');

		$db->autocommit(FALSE); // to rollback insertion if update fail


		$res = $db->query("Delete FROM lab_devices WHERE id =$id");
		if ($res) {
			loglog('Delete', 'lab_devices', $id, "Record were Successfuly Deleted", 'lab_devices.php');

			$db->commit();
			$op['is_success'] = true;
			$op['data'] 	  = "Record were Successfuly Deleted";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Delete', 'lab_devices', $id, "$db-error", 'lab_devices.php');
			$db->rollback();
			$op['is_success'] = false;
			$op['data'] 	  = "Error: Delete Failed";
			echo json_encode($op);
			exit;
		}
	}

	if ($_POST['type'] == "create") {


		$device_name 	 	= $_POST["device_name"];
		$device_test_name 	= $_POST["test_name"];
		$product_type_id_fk 	= $_POST["product_type_id_fk"];
		$product_detail_type_id_fk 	= isset($_POST["product_detail_type_id_fk"]) ? $_POST["product_detail_type_id_fk"] : 0;
		$mode 	= isset($_POST["mode"]) ? $_POST["mode"] : 'all';

		$cond = $product_detail_type_id_fk > 0 ? " AND product_detail.product_detail_id = $product_detail_type_id_fk" : "";
		$limit = $mode == 'single' ? "LIMIT 1" : "";

		$res = $db->query("SELECT product_id,product_detail.product_detail_id,product_detail.product_detail_name FROM `product`
									join product_detail on product.product_id = product_detail.product_id_fk 
									WHERE product_id =$product_type_id_fk and product_detail.is_deleted = 0 $cond $limit; ");

		// Initialize variables for database operations
		$op = array('is_success' => false, 'data' => '');
		$db->autocommit(FALSE); // Start transaction
		$insert_count = 0;

		if ($res && mysqli_num_rows($res) > 0) {
			// Loop through each record found and insert into lab_devices
			while ($row = $res->fetch_assoc()) {
				// Set test_code and is_detail based on mode
				if ($mode == 'single') {
					$test_code = $row['product_id']; // Use product_id as test_code
					$is_detail = 0; // Set is_detail to 0 for mode 'single'
				} else {
					$test_code = $row['product_detail_id']; // Use product_detail_id as test_code
					$is_detail = 1; // Since we're dealing with product_detail, set is_detail to 1
				}
				$is_active = 1; // Default to active

				$sql = "INSERT INTO `lab_devices`(`instrument_type`, `test_name`, `test_code`, `is_detail`, `is_active`) 
						VALUES ('$device_name','$device_test_name','$test_code','$is_detail','$is_active')";

				$insert_res = $db->query($sql);
				if ($insert_res) {
					$insert_count++;
				} else {
					// If any insert fails, rollback and exit
					loglog('Fail Add', 'lab_devices', 0, "Failed to insert lab device for product_detail_id: {$row['product_detail_id']} Error: ($db->error)", 'lab_devices.php');
					$db->rollback();
					$op['is_success'] = false;
					$op['data'] = "Error occurred while inserting lab devices. Transaction rolled back.";
					echo json_encode($op);
					exit;
				}
			}
		} else {
			// No records found or query failed
			$db->rollback();
			$op['is_success'] = false;
			$op['data'] = "No product details found for the selected product type.";
			echo json_encode($op);
			exit;
		}
		// If we reach here, all inserts were successful
		if ($insert_count > 0) {
			loglog('Add', 'lab_devices', 0, "Added Successfully ($insert_count lab devices for $device_name)", 'lab_devices.php');
			$db->commit();
			$op['is_success'] = true;
			$op['data'] = "Successfully added $insert_count lab device(s)";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Add', 'lab_devices', 0, "No lab devices were added", 'lab_devices.php');
			$db->rollback();
			$op['is_success'] = false;
			$op['data'] = "No lab devices were added";
			echo json_encode($op);
			exit;
		}
	}
} else {
	header("Location:../");
	exit;
}
?>