<?php
if (!isset($_SESSION)) {
	session_start();
}
if (!isset($_SESSION['is_login'])) {
	header("location: login.php");
?>
	<script>
		window.location = "login.php";
	</script>
<?php
}


date_default_timezone_set($_SESSION['system_time_zone']);

if (isset($_POST['type']) || isset($_GET['type'])) {
	require_once "db_connect.php";


	if (isset($_GET['type']) && ($_GET['type'] == "load")) {

		$branch_id_fk 		= $_SESSION['branch_id_fk'];

		$cond = " AND S.branch_id_fk =$branch_id_fk";

		if ($_SESSION['user_type_id_fk'] < 2) {
			$cond = "";
		}



		$table  =  "(SELECT 
							staff_id,
							username,
							full_name,
							phone_number,
							profile_img,
							login_count,
							user_type,
							permission_name,
							IF(S.is_deleted =0,'Active',IF(S.is_deleted =1,'Disabled','Deleted')) AS status,
							S.is_deleted,
							branch_name,
							department_name,
							S.city_name,
							S.country_name

							


							

						FROM
							staff S
							LEFT JOIN permission P ON (P.permission_id = S.permission_id_fk )
							LEFT JOIN user_type UT ON (UT.user_type_id = S.user_type_id_fk)

							LEFT JOIN branch BT ON (S.branch_id_fk = BT.branch_id )
							
							LEFT JOIN department DEPT ON (S.department_id_fk = DEPT.department_id )
							
							
							
						WHERE
							 S.is_deleted < 2  $cond
						) AS ALLTBL";


		$primaryKey = 'staff_id';
		$columns =  array(
			array('db' => 'staff_id', 'dt' => 0),
			array('db' => 'username', 'dt' => 1),
			array('db' => 'full_name',  'dt' => 2),
			array('db' => 'phone_number',  'dt' => 3),
			array('db' => 'login_count',  'dt' => 4),
			array('db' => 'user_type',  'dt' => 5),
			array('db' => 'permission_name',  'dt' => 6),
			array('db' => 'department_name',  'dt' => 7),
			// array( 'db' => 'branch_name',  'dt' => 8 ),
			array('db' => 'profile_img',  'dt' => 8),
			array('db' => 'status',  'dt' => 9),
			array('db' => 'is_deleted',  'dt' => 10),

		);



		$ords 		= '';
		$fltr 		= '';
		$limit 		= "";


		// SQL server connection information
		$sql_details = array(
			'user' => $mysql_user,
			'pass' => $mysql_password,
			'db'   => $mysql_db,
			'host' => $mysql_server
		);
		require('ssp.php');
		echo json_encode(
			// SSP::complex_optimized( $_GET, $sql_details, $table, $primaryKey, $columns ,$fltr, $ords, $limit )
			SSP::complex($_GET, $sql_details, $table, $primaryKey, $columns, null, '')

		);
		exit;
	}


	if ($_POST['type'] == "get") {

		$op  = array('is_success' => false, 'data' => array());

		$res = $db->query("SELECT 	staff_id,
										username,
										full_name
								FROM staff S

								WHERE S.is_deleted = 0");
		if ($res) {
			while ($row = $res->fetch_assoc()) {
				$result['staff_id'] 	= $row['staff_id'];
				$result['username'] 	= $row['username'];
				$result['full_name'] 	= $row['full_name'];
				array_push($op['data'], $result);
			}
			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		} else {
			$op['is_success'] = false;
			$op['data'] = 'Error Has Occure';
			echo json_encode($op);
			exit;
		}
	}

	if ($_POST['type'] == "get_user_type") {

		$op  = array('is_success' => false, 'data' => array());

		$res = $db->query("SELECT 	user_type_id,
										user_type

								FROM user_type 

								WHERE is_deleted = 0
								ORDER BY user_type_id DESC");
		if ($res) {
			while ($row = $res->fetch_assoc()) {
				$result['user_type_id'] 	= $row['user_type_id'];
				$result['user_type'] 		= $row['user_type'];
				array_push($op['data'], $result);
			}
			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		} else {
			$op['is_success'] = false;
			$op['data'] = 'Error Has Occure';
			echo json_encode($op);

			exit;
		}
	}

	if ($_POST['type'] == "get_log") {


		$pid 		   = $_POST['id'];
		$tbl 		   = $_POST['table'];

		$op  = array('is_success' => false, 'data' => array());


		$res = $db->query("SELECT
									log_id,
									log_type,
									log_table_name,
									log_primary_id_fk,
									log_second_id_fk,
									log_third_id_fk,
									log_action,
									page_name,
									log_timestamp,
									staff_id_fk,
									username
									
								FROM 	system_log SL
										
								LEFT JOIN staff S ON (S.staff_id = SL.staff_id_fk )
								WHERE SL.log_primary_id_fk = $pid AND log_table_name = '$tbl'
								ORDER BY log_timestamp DESC");
		if ($res) {


			while ($row = $res->fetch_assoc()) {

				$result['log_id']  				= $row['log_id'];
				$result['log_type']  			= $row['log_type'];
				$result['log_table_name']  		= $row['log_table_name'];
				$result['log_primary_id_fk']  	= $row['log_primary_id_fk'];
				$result['log_second_id_fk']  	= $row['log_second_id_fk'];
				$result['log_third_id_fk']  	= $row['log_third_id_fk'];
				$result['log_action']  			= $row['log_action'];
				$result['page_name']  			= $row['page_name'];
				$result['log_timestamp']  		= $row['log_timestamp'];
				$result['staff_id_fk']  		= $row['staff_id_fk'];
				$result['username']  			= $row['username'];

				array_push($op['data'], $result);
			}

			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		} else {
			$op['is_success'] = false;
			$op['data'] 	  = $db->error;
			echo json_encode($op);

			exit;
		}
	}

	if ($_POST['type'] == "get_user_log") {


		$by 		   = $_POST['id'];

		$op  = array('is_success' => false, 'data' => array());


		$res = $db->query("SELECT
									log_id,
									log_type,
									log_table_name,
									log_primary_id_fk,
									log_second_id_fk,
									log_third_id_fk,
									log_action,
									page_name,
									log_timestamp,
									staff_id_fk,
									username
									
								FROM 	system_log SL
										
								LEFT JOIN staff S ON (S.staff_id = SL.staff_id_fk )
								WHERE SL.staff_id_fk = $by
								ORDER BY log_timestamp DESC");
		if ($res) {


			while ($row = $res->fetch_assoc()) {

				$result['log_id']  				= $row['log_id'];
				$result['log_type']  			= $row['log_type'];
				$result['log_table_name']  		= $row['log_table_name'];
				$result['log_primary_id_fk']  	= $row['log_primary_id_fk'];
				$result['log_second_id_fk']  	= $row['log_second_id_fk'];
				$result['log_third_id_fk']  	= $row['log_third_id_fk'];
				$result['log_action']  			= $row['log_action'];
				$result['page_name']  			= $row['page_name'];
				$result['log_timestamp']  		= $row['log_timestamp'];
				$result['staff_id_fk']  		= $row['staff_id_fk'];
				$result['username']  			= $row['username'];

				array_push($op['data'], $result);
			}

			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		} else {
			$op['is_success'] = false;
			$op['data'] 	  = $db->error;
			echo json_encode($op);

			exit;
		}
	}

	if ($_POST['type'] == "get_country") {

		$json_country 	= file_get_contents("json/countries.json");
		$json_continent = file_get_contents("json/continents.json");

		$json_country_iterator 	= 	new RecursiveIteratorIterator(
			new RecursiveArrayIterator(json_decode($json_country, TRUE)),
			RecursiveIteratorIterator::SELF_FIRST
		);

		$json_continent_iterator = 	new RecursiveIteratorIterator(
			new RecursiveArrayIterator(json_decode($json_continent, TRUE)),
			RecursiveIteratorIterator::SELF_FIRST
		);

		$op  = array('is_success' => true, 'data' => array());

		$lop = 0;

		foreach ($json_country_iterator as $key => $val) {



			if (is_array($val)) {



				if ($key != 'languages') {

					if ($lop > 0) {
						array_push($op['data'], $result);
						$lop = 0;
						$result['language_symbol'] = array();
					}
					$result['country_code'] = $key;
					$lop++;
				} else {
					for ($i = 0; $i < count($val); $i++) {
						$result['language_symbol'][$i] = $val[$i];
					}
				}
			} else {

				if ($key == 'continent') {
					foreach ($json_continent_iterator as $key_c => $val_c) {
						if ($key == $key_c) {
							$result['continent'] = $val_c;
						}
					}
				} else {

					if (is_numeric($key)) {
					} else {
						$result[$key] = $val;
					}
				}
			}
			// echo $key . "_".$val;





		}

		echo json_encode($op);
	}

	if ($_POST['type'] == "get_city") {

		$country_code = $_POST['country_code'];

		$json_city 	= file_get_contents("json/cities.json");

		$json_city_iterator 	= 	json_decode($json_city, true);;


		$op  = array('is_success' => true, 'data' => array());
		$x = 0;
		foreach ($json_city_iterator as $val) {
			$x++;
			$crnt_contry = $val['country'];

			if (strtolower($crnt_contry) == strtolower($country_code)) {

				$result['country_code'] = $val['country'];
				$result['city_name'] 	= $val['name'];
				array_push($op['data'], $result);
			}
		}

		$op['is_success'] = true;
		echo json_encode($op);
		exit;
	}


	if ($_POST['type'] == "get_edit") {

		$id = $_POST['edited_id'];
		$op  = array('is_success' => false, 'data' => array());

		$res = $db->query("SELECT
										staff_id,
										username,
									 	full_name,
									 	email,
									 	phone_number,
									 	is_view,
									 	login_time_from,
									 	login_time_to,
									 	login_time_limit,
									 	box_id_fk,
									 	system_box_id_fk,
									 	permission_id_fk,
									 	user_type_id_fk,
									 	department_id_fk,
									 	branch_id_fk,
									 	city_name,
									 	country_name,
									 	default_stock_id_fk,
									 	system_stock_id_fk,
									 	system_staff_id_fk,
									 	S.product_type_id_fk,
									 	p.product_name as product_type_name,
									 	view_type

									FROM
										staff S
										LEFT JOIN product as p ON p.product_id = S.product_type_id_fk 
									WHERE
										 S.is_deleted < 2 AND S.staff_id = $id 

								");
		if ($res) {


			while ($row = $res->fetch_assoc()) {

				$result['staff_id']  			= $row['staff_id'];
				$result['username']  			= $row['username'];
				$result['full_name']  			= $row['full_name'];
				$result['email']  				= $row['email'];
				$result['phone_number']  		= $row['phone_number'];
				$result['is_view']  			= $row['is_view'];
				$result['login_time_from']  	= $row['login_time_from'];
				$result['login_time_to']  		= $row['login_time_to'];
				$result['login_time_limit']  	= $row['login_time_limit'];
				$result['box_id_fk']  			= $row['box_id_fk'];
				$result['system_box_id_fk']  	= $row['system_box_id_fk'];
				$result['permission_id_fk']  	= $row['permission_id_fk'];
				$result['user_type_id_fk']  	= $row['user_type_id_fk'];
				$result['department_id_fk']  	= $row['department_id_fk'];
				$result['branch_id_fk']  		= $row['branch_id_fk'];
				$result['city_name']  			= $row['city_name'];
				$result['country_name']  		= $row['country_name'];
				$result['default_stock_id_fk']  = $row['default_stock_id_fk'];
				$result['system_stock_id_fk']  	= $row['system_stock_id_fk'];
				$result['system_staff_id_fk']  	= $row['system_staff_id_fk'];
				$result['product_type_id_fk']  	= $row['product_type_id_fk'];
				$result['product_type_name']  	= $row['product_type_name'];
				$result['view_type']  			= $row['view_type'];


				array_push($op['data'], $result);
			}
			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		} else {
			$op['is_success'] = false;
			$op['data'] 	  = $db->error;
			echo json_encode($op);

			exit;
		}
	}

	if ($_POST['type'] == "get_role") {

		$id = $_POST['edited_id'];
		$op  = array('is_success' => false, 'role' => array(), 'permission' => array(), 'user_role' => array());

		$res = $db->query("SELECT

										role_id,
										role_name

									FROM
										 role R 
									WHERE
										 R.is_deleted = 0  

								");


		$res2 = $db->query("SELECT
										role_permission_id,
										role_id_fk,
										permission_id_fk,
										role_name,
										permission_name

									FROM
										role_permission RP
										LEFT JOIN role R ON (R.role_id = RP.role_id_fk)
										LEFT JOIN permission P ON (P.permission_id = RP.permission_id_fk)
									WHERE
										 RP.is_deleted = 0  

								");

		if ($res && $res2) {


			while ($row = $res->fetch_assoc()) {


				$result1['role_name']  					= $row['role_name'];
				$result1['role_id']  					= $row['role_id'];



				array_push($op['role'], $result1);
			}

			while ($row = $res2->fetch_assoc()) {

				$result['role_permission_id']  			= $row['role_permission_id'];
				$result['role_id_fk']  					= $row['role_id_fk'];
				$result['permission_id_fk']  			= $row['permission_id_fk'];
				$result['role_name']  					= $row['role_name'];
				$result['permission_name']  			= $row['permission_name'];



				array_push($op['permission'], $result);
			}


			$res3 = $db->query("SELECT
										staff_role_permission_id,
										role_id_fk,
										permission_id_fk,
										staff_id_fk
									FROM
										staff_role_permission SRP
										
									WHERE
										 SRP.is_deleted = 0  AND SRP.staff_id_fk=$id
								");


			if ($res3) {

				while ($row = $res3->fetch_assoc()) {

					$result2['role_id_fk']  				= $row['role_id_fk'];
					$result2['permission_id_fk']  			= $row['permission_id_fk'];

					array_push($op['user_role'], $result2);
				}
			}



			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		} else {
			$op['is_success'] = false;
			$op['data'] 	  = $db->error;
			echo json_encode($op);

			exit;
		}
	}

	if ($_POST['type'] == "password") {

		$id 					= $_POST['password_id'];

		$password				= ($_POST["ch_password"]);
		$re_password			= ($_POST["ch_re_password"]);


		$op  = array('is_success' => false, 'data' => '');



		if ($password != $re_password) {
			loglog('Fail Update', "staff", $id, "Passwords does not match.", 'users.php');

			$op['is_success'] = false;
			$op['data'] 	  = "Passwords does not match.";
			echo json_encode($op);
			exit;
		}

		$password = stripslashes($password);
		$password = mysqli_real_escape_string($db, $password);

		$password = password_hash($password, PASSWORD_ARGON2ID);


		$reg_date = date("Y-m-d H:i:s", time());

		$by 		= $_SESSION['user_id'];
		$lastaction = "Change User Password";

		$update_qry = "UPDATE staff SET  	
									password		='$password',
									last_action 	='$lastaction',
									updated_at		='$reg_date',
									last_action_by	='$by' 
							WHERE staff_id = $id";


		$res = $db->query($update_qry);
		if ($res) {
			loglog('Update', "staff", $id, "Password Successfully Changed", 'users.php');
			$op['is_success'] = true;
			$op['data'] 	 	  = "Password Successfully Changed";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Update', "staff", $id, "$db->error", 'users.php');
			$op['is_success'] = false;
			$op['data'] 	  	= "Error: Failed Change Password";
			echo json_encode($op);
			exit;
		}
	}


	if ($_POST['type'] == "update") {

		$id 				= $_POST['edited_id'];
		$username 			= $_POST["edit_username"];
		$full_name 			= $_POST["edit_full_name"];
		$email				= $_POST["edit_email"];
		$phone_number		= $_POST["edit_phone_number"];
		$is_view			= (int)$_POST["edit_is_view"];
		$login_time_limit	= (int)$_POST["edit_login_time_limit"];
		$login_time_from	= $_POST["edit_login_time_from"];
		$login_time_to		= $_POST["edit_login_time_to"];

		$product_type_id_fk = !empty($_POST["edit_product_type_id_fk"]) && (int)$_POST["edit_product_type_id_fk"] > 0 ? (int)$_POST["edit_product_type_id_fk"] : 'NULL';
		$user_type_id_fk	= (int)$_POST["edit_user_type_id_fk"];
		$view_type			= (int)$_POST["edit_view_type"];
		$permission_id_fk	= (int)$_POST["edit_permission_id_fk"];
		$country_name		= $_POST["edit_country_name"];
		$city_name			= $_POST["edit_city_name"];

		$branch_id_fk = isset($_POST["edit_branch_id_fk"]) ? $_POST["edit_branch_id_fk"] : 0;

		$department_id_fk		= isset($_POST["edit_department_id_fk"]) ? $_POST["edit_department_id_fk"] : 0;

		$box_id_fk	= isset($_POST["edit_box_id_fk"]) ? $_POST["edit_box_id_fk"] : 0;

		$default_stock_id_fk	= isset($_POST["edit_default_stock_id_fk"]) ? $_POST["edit_default_stock_id_fk"] : 0;

		$system_box_id_fk		= isset($_POST["edit_system_box_id_fk"]) ? implode(',', $_POST["edit_system_box_id_fk"]) : '';

		$system_stock_id_fk		= isset($_POST["edit_system_stock_id_fk"]) ? implode(',', $_POST["edit_system_stock_id_fk"]) : '';
		$system_staff_id_fk		= isset($_POST["edit_system_staff_id_fk"]) ? implode(',', $_POST["edit_system_staff_id_fk"]) : '';

		if ($login_time_from == '') {
			$login_time_from = '00:00';
		}
		if ($login_time_to == '') {
			$login_time_to = '00:00';
		}

		if (!preg_match('/^[a-zA-Z0-9_.@ ]+$/', trim($username))) {

			loglog('Fail Update', "staff", $id, "Username can only contain letters, numbers, underscores, (@), (.) and Space ($username)", 'users.php');
			$op['is_success'] = false;
			$op['data'] 	  = "Username can only contain letters, numbers, underscores, (@), (.) and Space";
			echo json_encode($op);
			exit;
		}

		$op  = array('is_success' => false, 'data' => '');


		$res = $db->query("SELECT username 

								FROM staff S

								WHERE username = '$username' AND S.is_deleted=0 AND staff_id!=$id");

		if (mysqli_num_rows($res) > 0) {
			loglog('Fail Update', "staff", $id, "Error: Duplicated User Name ($username)", 'users.php');

			$op['is_success'] = false;
			$op['data'] 	  = "Error: Duplicated User Name";
			echo json_encode($op);
			exit;
		}




		if ($user_type_id_fk < 3) {

			if ($user_type_id_fk < $_SESSION['user_type_id_fk']) {
				loglog('Fail Update', "staff", $id, "Only SuperAdmin Can Make SuperAdmin User and Admin Can Make Admin User! ($username)", 'users.php');

				$op['is_success'] = false;
				$op['data'] 	  = "Only SuperAdmin Can Make SuperAdmin User and Admin Can Make Admin User!";
				echo json_encode($op);
				exit;
			}
		}


		$reg_date 	= date("Y-m-d H:i:s", time());

		$res = $db->query("SELECT * FROM staff S WHERE staff_id=$id");

		$before_update = $res->fetch_assoc();

		$db->autocommit(FALSE);

		$lastaction = "Update User information";
		$by 		= $_SESSION['user_id'];

		$update_qry = "UPDATE staff SET 
								username			='$username',
								full_name			='$full_name',
								email				='$email',
								phone_number		='$phone_number',
								is_view				='$is_view',
								login_time_from		='$login_time_from',
								login_time_to		='$login_time_to',
								login_time_limit	='$login_time_limit',
								box_id_fk			='$box_id_fk',
								system_box_id_fk	='$system_box_id_fk',
								permission_id_fk	='$permission_id_fk',
								user_type_id_fk		='$user_type_id_fk',
								department_id_fk	='$department_id_fk',
								branch_id_fk		='$branch_id_fk',
								city_name			='$city_name',
								country_name		='$country_name',
								default_stock_id_fk	='$default_stock_id_fk',
								system_stock_id_fk	='$system_stock_id_fk',
								system_staff_id_fk	='$system_staff_id_fk',
								product_type_id_fk	=" . ($product_type_id_fk !== 'NULL' ? $product_type_id_fk : 'NULL') . ",
								view_type			='$view_type',
								last_action 		='$lastaction',
								updated_at			='$reg_date',
								last_action_by		='$by' 
							WHERE staff_id = $id";


		$res = $db->query($update_qry);
		if ($res) {


			$error = ImageUploader('edit_profile_img', 'user-img', 'staff', 'profile_img', $id, 'staff_id', '');

			$res = $db->query("SELECT * FROM staff S WHERE staff_id=$id");

			$after_update = $res->fetch_assoc();

			$updated_columns 		= array_diff_assoc($after_update, $before_update);
			$updated_columns_before = array_diff_assoc($before_update, $after_update);

			loglog('Update', "staff", $id, "Record Successfully Updated", 'users.php', $updated_columns_before, $updated_columns);

			$db->commit();
			$op['is_success'] = true;
			$op['data'] 	 	  = "Record Successfully Updated";
			$op['image'] 	 	  = $error;
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Update', "staff", $id, "$db->error", 'users.php');

			$db->rollback();
			$op['is_success'] = false;
			$op['data'] 	  	= "Error: Update Failed";
			echo json_encode($op);
			exit;
		}
	}

	if ($_POST['type'] == "delete-img") {

		$id 		=	$_POST["id"];
		$table 		=	$_POST["table"];
		$pri_key 	=	$_POST["pri_key"];
		$field_name =	$_POST["field_name"];

		$reg_date 	= 	date("Y-m-d H:i:s", time());
		$lastaction = 	"Delete file";

		$op  = array('is_success' => false, 'data' => '');



		$res = $db->query("SELECT 	$field_name 											
								FROM 	$table
								WHERE   $pri_key = $id ");
		if ($res) {

			while ($row = $res->fetch_assoc()) {

				$path  			= "../" . $row[$field_name];

				if (file_exists($path)) {
					@unlink($path);
				} else {
					$error =  "Old File is not exists";
				}
			}
			$by = $_SESSION['user_id'];
			$res = $db->query("UPDATE $table SET 	
										$field_name 	= '' ,
										last_action		= '$lastaction',
										updated_at		= '$reg_date',
										last_action_by	= '$by' 
	      							WHERE $pri_key =$id");

			if ($res) {
				loglog('Delete File', "$table", $id, "Image Deleted Successfully", 'users.php');

				$op['is_success'] = true;
				$op['data'] 	  = "Image Deleted Successfully";
				echo json_encode($op);
				exit;
			}
		} else {
			loglog('Fail Delete File', "$table", $id, "$db->error", 'users.php');

			$op['is_success'] = false;
			$op['data'] 	  = "Error: Delete Failed";
			echo json_encode($op);
			exit;
		}
	}

	if ($_POST['type'] == "active_deactive") {

		$id 		= ($_POST["obj_id"]);
		$set 		= ($_POST["set_type"]);
		$reg_date 	= date("Y-m-d H:i:s", time());
		$lastaction = "Activated|De-Activated";


		$op  = array('is_success' => false, 'data' => '');

		if ($_SESSION['user_type_id_fk'] != 1 && $_SESSION['user_type_id_fk'] != 2) {
			loglog('Fail Activate', 'staff', $id, "You are Not Allowed to Activated or De-Activated Users Only Admin and SuperAdmin Can.", 'users.php');

			$op['is_success'] = false;
			$op['data'] 	  = "You are Not Allowed to Activated or De-Activated Users Only Admin and SuperAdmin Can.";
			echo json_encode($op);
			exit;
		}

		if ($set == 1) {



			$res = $db->query("SELECT * FROM staff WHERE is_deleted=0 AND staff_id='$id'");

			while ($row = $res->fetch_assoc()) {

				$user_type_id_fk  			= $row['user_type_id_fk'];
			}

			// check if user type = 1 superadmin or type =2 admin we should prevent deleting until the system has at least one type remain

			if ($user_type_id_fk == 1) {

				$res = $db->query("SELECT * FROM staff WHERE is_deleted=0 AND staff_id!='$id' AND user_type_id_fk=$user_type_id_fk");

				if (mysqli_num_rows($res) == 0) {
					loglog('Fail Activate', 'staff', $id, "Can Not De-Activated SuperAdmin Account, it should be at least one SuperAdmin Account in the system", 'users.php');

					$op['is_success'] = false;
					$op['data'] 	  = "Can Not De-Activated SuperAdmin Account, it should be at least one SuperAdmin Account in the system";
					echo json_encode($op);
					exit;
				}
			}

			if ($user_type_id_fk == 2) {

				$res = $db->query("SELECT * FROM staff WHERE is_deleted=0 AND staff_id!='$id' AND user_type_id_fk=$user_type_id_fk");

				if (mysqli_num_rows($res) == 0) {
					loglog('Fail Activate', 'staff', $id, "Can Not De-Activated Admin Account, it should be at least one Admin Account in the system", 'users.php');

					$op['is_success'] = false;
					$op['data'] 	  = "Can Not De-Activated Admin Account, it should be at least one Admin Account in the system";
					echo json_encode($op);
					exit;
				}
			}
		}


		$by = $_SESSION['user_id'];

		$res = $db->query("UPDATE staff SET 		
	      							is_deleted 		= $set,
	      							deleted_at 		= '$reg_date',
	      							last_action		= '$lastaction',
	      							updated_at		= '$reg_date',
	      							last_action_by	= '$by' 
	      						WHERE staff_id =$id");
		if ($res) {
			loglog('Activate/De-Activated', 'staff', $id, "Operation Completed Successfully", 'users.php');

			$op['is_success'] = true;
			$op['data'] 	  = "Operation Completed Successfully";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Activate/De-Activated', 'staff', $id, "$db->error", 'users.php');

			$op['is_success'] = false;
			$op['data'] 	  = "Error: Operation Failed";
			echo json_encode($op);
			exit;
		}
	}




	if ($_POST['type'] == "delete") {

		$id 		= ($_POST["obj_id"]);
		$reg_date 	= date("Y-m-d H:i:s", time());
		$lastaction = "Delete User";


		$op  = array('is_success' => false, 'data' => '');

		if ($_SESSION['user_type_id_fk'] != 1 && $_SESSION['user_type_id_fk'] != 2) {
			loglog('Fail Delete', 'staff', $id, "You are Not Allowed Delete Users Only Admin and SuperAdmin Can.", 'users.php');
			$op['is_success'] = false;
			$op['data'] 	  = "You are Not Allowed Delete Users Only Admin and SuperAdmin Can.";
			echo json_encode($op);
			exit;
		}

		$res = $db->query("SELECT * FROM staff WHERE is_deleted=0 AND staff_id='$id'");

		while ($row = $res->fetch_assoc()) {

			$user_type_id_fk  			= $row['user_type_id_fk'];
		}

		// check if user type = 1 superadmin or type =2 admin we should prevent deleting until the system has at least one type remain

		if ($user_type_id_fk == 1) {

			$res = $db->query("SELECT * FROM staff WHERE is_deleted=0 AND staff_id!='$id' AND user_type_id_fk=$user_type_id_fk");

			if (mysqli_num_rows($res) == 0) {
				loglog('Fail Delete', 'staff', $id, "Can Not Delete SuperAdmin Account, it should be at least one SuperAdmin Account in the system", 'users.php');

				$op['is_success'] = false;
				$op['data'] 	  = "Can Not Delete SuperAdmin Account, it should be at least one SuperAdmin Account in the system";
				echo json_encode($op);
				exit;
			}
		}

		if ($user_type_id_fk == 2) {

			$res = $db->query("SELECT * FROM staff WHERE is_deleted=0 AND staff_id!='$id' AND user_type_id_fk=$user_type_id_fk");

			if (mysqli_num_rows($res) == 0) {
				loglog('Fail Delete', 'staff', $id, "Can Not Delete Admin Account, it should be at least one Admin Account in the system", 'users.php');

				$op['is_success'] = false;
				$op['data'] 	  = "Can Not Delete Admin Account, it should be at least one Admin Account in the system";
				echo json_encode($op);
				exit;
			}
		}

		$by = $_SESSION['user_id'];
		$db->autocommit(FALSE); // to rollback insertion if update fail


		$res = $db->query("UPDATE staff SET 		
		      						is_deleted 		= 2,
		      						deleted_at 		= '$reg_date',
		      						last_action		= '$lastaction',
		      						updated_at		= '$reg_date',
		      						last_action_by	= '$by' 
	      						WHERE staff_id =$id");
		if ($res) {
			loglog('Delete', 'staff', $id, "Record were Successfuly Deleted", 'users.php');

			$db->commit();
			$op['is_success'] = true;
			$op['data'] 	  = "Record were Successfuly Deleted";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Delete', 'staff', $id, "$db-error", 'users.php');
			$db->rollback();
			$op['is_success'] = false;
			$op['data'] 	  = "Error: Delete Failed";
			echo json_encode($op);
			exit;
		}
	}

	if ($_POST['type'] == "create") {


		$username 			= $_POST["username"];
		$full_name 			= $_POST["full_name"];
		$email				= $_POST["email"];
		$phone_number		= $_POST["phone_number"];
		$is_view			= (int)$_POST["is_view"];
		$login_time_limit	= (int)$_POST["login_time_limit"];
		$login_time_from	= $_POST["login_time_from"];
		$login_time_to		= $_POST["login_time_to"];

		$product_type_id_fk = !empty($_POST["product_type_id_fk"]) && (int)$_POST["product_type_id_fk"] > 0 ? (int)$_POST["product_type_id_fk"] : 'NULL';
		$user_type_id_fk	= (int)$_POST["user_type_id_fk"];
		$view_type			= (int)$_POST["view_type"];
		$permission_id_fk	= (int)$_POST["permission_id_fk"];
		$country_name		= $_POST["country_name"];
		$city_name			= $_POST["city_name"];
		$password			= $_POST["password"];
		$re_password		= $_POST["re_password"];


		$branch_id_fk = isset($_POST["branch_id_fk"]) ? $_POST["branch_id_fk"] : 0;

		$department_id_fk		= isset($_POST["department_id_fk"]) ? $_POST["department_id_fk"] : 0;

		$box_id_fk	= isset($_POST["box_id_fk"]) ? $_POST["box_id_fk"] : 0;

		$default_stock_id_fk	= isset($_POST["default_stock_id_fk"]) ? $_POST["default_stock_id_fk"] : 0;

		$system_box_id_fk		= isset($_POST["system_box_id_fk"]) ? implode(',', $_POST["system_box_id_fk"]) : '';

		$system_stock_id_fk		= isset($_POST["system_stock_id_fk"]) ? implode(',', $_POST["system_stock_id_fk"]) : '';
		$system_staff_id_fk		= isset($_POST["system_staff_id_fk"]) ? implode(',', $_POST["system_staff_id_fk"]) : '';

		if ($login_time_from == '') {
			$login_time_from = '00:00';
		}
		if ($login_time_to == '') {
			$login_time_to = '00:00';
		}

		if (!preg_match('/^[a-zA-Z0-9_.@ ]+$/', trim($_POST["username"]))) {

			loglog('Fail Add', 'staff', 0, "Failed Add User ($username) Username can only contain letters, numbers, underscores, (@), (.) and Space", 'users.php');
			$op['is_success'] = false;
			$op['data'] 	  = "Username can only contain letters, numbers, underscores, (@), (.) and Space";
			echo json_encode($op);
			exit;
		}


		if ($user_type_id_fk < 3) {

			if ($user_type_id_fk < $_SESSION['user_type_id_fk']) {
				loglog('Fail Add', 'staff', 0, "Failed Add User ($username) Only SuperAdmin Can Add SuperAdmin User and Admin Can Add Admin User!", 'users.php');

				$op['is_success'] = false;
				$op['data'] 	  = "Only SuperAdmin Can Add SuperAdmin User and Admin Can Add Admin User!";
				echo json_encode($op);
				exit;
			}
		}

		$res = $db->query("SELECT username 

								FROM staff S

								WHERE username = '$username' AND S.is_deleted=0");

		if (mysqli_num_rows($res) > 0) {
			loglog('Fail Add', 'staff', 0, "Failed Add User ($username) Error Duplicated User Name", 'users.php');

			$op['is_success'] = false;
			$op['data'] 	  = "Error Duplicated User Name";
			echo json_encode($op);
			exit;
		}



		if ($re_password != $password) {
			loglog('Fail Add', 'staff', 0, "Failed Add User ($username) Error: Passwords does not Match!.", 'users.php');
			$op['is_success'] = false;
			$op['data'] 	  = "Error: Passwords does not Match!.";
			echo json_encode($op);
			exit;
		}

		$password = stripslashes($password);
		$password = mysqli_real_escape_string($db, $password);

		$password = password_hash($password, PASSWORD_ARGON2ID);
		// PASSWORD_DEFAULT		bcrypt
		// PASSWORD_BCRYPT		CRYPT_BLOWFISH 
		// PASSWORD_ARGON2I		Argon2i
		// PASSWORD_ARGON2ID	Argon2id

		$delete 	= 0;
		$reg_date 	= date("Y-m-d H:i:s", time());
		$lastaction = "Add New User";
		$by 		= $_SESSION['user_id'];

		$db->autocommit(FALSE);


		$sql = "INSERT INTO staff (	
										 	username,
										 	password,
										 	full_name,
										 	email,
										 	phone_number,
										 	is_view,
										 	login_time_from,
										 	login_time_to,
										 	login_time_limit,
										 	box_id_fk,
										 	system_box_id_fk,
										 	permission_id_fk,
										 	user_type_id_fk,
										 	department_id_fk,
										 	branch_id_fk,
										 	city_name,
										 	country_name,
										 	default_stock_id_fk,
										 	system_stock_id_fk,
										 	system_staff_id_fk,
											product_type_id_fk,
										 	view_type,
											created_by,
											created_at,
										    updated_at,
											last_action,
											last_action_by)
									VALUES( 
											'$username',
											'$password',
											'$full_name',
											'$email',
											'$phone_number',
											'$is_view',
											'$login_time_from',
											'$login_time_to',
											'$login_time_limit',
											'$box_id_fk',
											'$system_box_id_fk',
											'$permission_id_fk',
											'$user_type_id_fk',
											'$department_id_fk',
											'$branch_id_fk',
											'$city_name',
											'$country_name',
											'$default_stock_id_fk',
											'$system_stock_id_fk',
											'$system_staff_id_fk',
											" . ($product_type_id_fk !== 'NULL' ? $product_type_id_fk : 'NULL') . ",
											'$view_type',
											'$by',
											'$reg_date',
											'$reg_date',
											'$lastaction',
											'$by')";
		$res = $db->query($sql);
		if ($res) {

			$id 		= 	$db->insert_id;


			$error = ImageUploader('profile_img', 'user-img', 'staff', 'profile_img', $id, 'staff_id', '');

			loglog('Add', 'staff', $id, "Added Successfully ($username)", 'users.php');
			$db->commit();
			$op['is_success'] = true;
			$op['data'] 	  = "Added Successfully";
			$op['image'] 	  = $error;
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Add', 'staff', 0, "Failed Add User ($username) Error:($db->error)", 'users.php');

			$db->rollback();
			$op['is_success'] = false;
			$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
			echo json_encode($op);
			exit;
		}
	}
} else {
	header("Location:../");
	exit;
}
?>